#!/bin/sh

productName="Sinevibes Array 4.0.1 (demo)"
plugin="SinevibesArray4.vst3"
presets="Presets"

echo "Thank you for using Sinevibes plugins!"
echo "Installing $productName on your system..."

home=~
echo "Your home folder: $home"

pluginFolder="$home/.vst3/Sinevibes"
presetsFolder="$home/.local/share/Sinevibes/Array v4"

if [ -e "$plugin" ]
then
    echo "Plugin source: $plugin"
else
    echo "ERROR: plugin file not found!"
    exit
fi

echo "Plugin target: $pluginFolder"

if [ -e "$presets" ]
then
    echo "Presets source: $presets"
else
    echo "ERROR: presets folder not found!"
    exit
fi

echo "Presets target: $presetsFolder"

echo "Creating all target folders..."

mkdir "$home/.vst3" 2>/dev/null
mkdir "$home/.vst3/Sinevibes" 2>/dev/null
mkdir "$home/.local/share" 2>/dev/null
mkdir "$home/.local/share/Sinevibes" 2>/dev/null
mkdir "$home/.local/share/Sinevibes/Array v4" 2>/dev/null

echo "Deleting previously installed files..."

rm -R "$pluginFolder/../$plugin" 2>/dev/null
rm -R "$pluginFolder/$plugin" 2>/dev/null
rm -R "$presetsFolder/$presets" 2>/dev/null

echo "Installing plugin and presets..."

cp -R "$plugin" "$pluginFolder"
cp -R "$presets" "$presetsFolder"
